/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.misc;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Predicate;
import net.geforcemods.securitycraft.blockentities.BlockChangeDetectorBlockEntity;
import net.geforcemods.securitycraft.blockentities.RiftStabilizerBlockEntity;
import net.geforcemods.securitycraft.blockentities.SecureRedstoneInterfaceBlockEntity;
import net.geforcemods.securitycraft.blockentities.SecurityCameraBlockEntity;
import net.geforcemods.securitycraft.blockentities.SonicSecuritySystemBlockEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class BlockEntityTracker<TE extends TileEntity> {
    public static final BlockEntityTracker<SonicSecuritySystemBlockEntity> SONIC_SECURITY_SYSTEM = new BlockEntityTracker<SonicSecuritySystemBlockEntity>(te -> 30);
    public static final BlockEntityTracker<BlockChangeDetectorBlockEntity> BLOCK_CHANGE_DETECTOR = new BlockEntityTracker<BlockChangeDetectorBlockEntity>(te -> te.getRange());
    public static final BlockEntityTracker<RiftStabilizerBlockEntity> RIFT_STABILIZER = new BlockEntityTracker<RiftStabilizerBlockEntity>(RiftStabilizerBlockEntity::getRange);
    public static final BlockEntityTracker<SecureRedstoneInterfaceBlockEntity> SECURE_REDSTONE_INTERFACE = new BlockEntityTracker<SecureRedstoneInterfaceBlockEntity>(SecureRedstoneInterfaceBlockEntity::getSenderRange);
    public static final BlockEntityTracker<SecurityCameraBlockEntity> FRAME_VIEWED_SECURITY_CAMERAS = new BlockEntityTracker<SecurityCameraBlockEntity>(be -> 0);
    private final Map<Integer, Collection<BlockPos>> trackedTileEntities = new ConcurrentHashMap<Integer, Collection<BlockPos>>();
    private final Function<TE, Integer> range;

    private BlockEntityTracker(Function<TE, Integer> range) {
        this.range = range;
    }

    public void track(TE te) {
        this.getTrackedTileEntities(te.func_145831_w()).add(te.func_174877_v().func_185334_h());
    }

    public void stopTracking(TE te) {
        this.getTrackedTileEntities(te.func_145831_w()).remove(te.func_174877_v());
    }

    public void clear() {
        this.trackedTileEntities.clear();
    }

    public List<TE> getTileEntitiesInRange(World world, BlockPos pos) {
        return this.getTileEntitiesInRange(world, new Vec3d((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p()));
    }

    public List<TE> getTileEntitiesInRange(World level, Vec3d pos) {
        return this.getTileEntitiesWithCondition(level, be -> this.canReach(be, pos));
    }

    public List<TE> getTileEntitiesAround(World level, BlockPos pos, int range) {
        return this.iterate(level, (list, bePos) -> {
            if (this.isInRange(pos, range, new Vec3d((double)bePos.func_177958_n(), (double)bePos.func_177956_o(), (double)bePos.func_177952_p()))) {
                list.add(level.func_175625_s(bePos));
            }
        });
    }

    public List<TE> getTileEntitiesWithCondition(World level, Predicate<TE> condition) {
        return this.iterate(level, (list, bePos) -> {
            TileEntity be = level.func_175625_s(bePos);
            if (be != null && condition.test(be)) {
                list.add(be);
            }
        });
    }

    private List<TE> iterate(World level, BiConsumer<List<TE>, BlockPos> listAdder) {
        Collection<BlockPos> blockEntities = this.getTrackedTileEntities(level);
        ArrayList returnValue = new ArrayList();
        Iterator<BlockPos> it = blockEntities.iterator();
        while (it.hasNext()) {
            BlockPos tePos = it.next();
            if (tePos != null) {
                try {
                    listAdder.accept(returnValue, tePos);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            it.remove();
        }
        return returnValue;
    }

    public Collection<BlockPos> getTrackedTileEntities(World world) {
        Collection<BlockPos> tileEntities = this.trackedTileEntities.get(world.field_73011_w.getDimension());
        if (tileEntities == null) {
            tileEntities = ConcurrentHashMap.newKeySet();
            this.trackedTileEntities.put(world.field_73011_w.getDimension(), tileEntities);
        }
        return tileEntities;
    }

    public boolean canReach(TE be, Vec3d pos) {
        return this.isInRange(be.func_174877_v(), this.range.apply(be), pos);
    }

    public boolean isInRange(BlockPos around, int range, Vec3d pos) {
        AxisAlignedBB testRange = new AxisAlignedBB(around).func_186662_g((double)range);
        return testRange.field_72340_a <= pos.field_72450_a && testRange.field_72338_b <= pos.field_72448_b && testRange.field_72339_c <= pos.field_72449_c && testRange.field_72336_d >= pos.field_72450_a && testRange.field_72337_e >= pos.field_72448_b && testRange.field_72334_f >= pos.field_72449_c;
    }
}

